/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.planning.mokos;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import cz.insophy.inplan.planning.mokos.Operation;
import cz.insophy.inplan.planning.mokos.Scheduler;
import cz.insophy.inplan.util.Tuple;
import java.util.List;
import java.util.Set;

public abstract class Processor {
    private Scheduler scheduler;
    private List<Processor> successors;

    public void setScheduler(Scheduler scheduler) {
        Preconditions.checkNotNull(scheduler);
        Preconditions.checkState(this.scheduler == null, "Scheduler cannot be set more than once.");
        this.scheduler = scheduler;
    }

    public void setSuccessors(List<Processor> successors) {
        Preconditions.checkNotNull(successors);
        Preconditions.checkState(this.successors == null, "Successors cannot be set more than once.");
        this.successors = ImmutableList.copyOf(successors);
    }

    protected Scheduler getScheduler() {
        return this.scheduler;
    }

    protected List<Processor> getSuccessors() {
        return this.successors;
    }

    protected Processor getDefaultSuccessor() {
        return this.successors != null && !this.successors.isEmpty() ? this.successors.get(0) : null;
    }

    public abstract Tuple<Processor, Set<Operation>> process(Set<Operation> var1);

    public void onOperationPlanned(Operation op) {
    }

    protected void checkOneSuccessor() {
        Preconditions.checkArgument(this.successors.size() == 1, "Processor of type " + this.getClass() + " must have one and only one successor.");
    }

    public boolean onPlanningStopping() {
        return true;
    }

    public void onPlanningFinished() {
    }

    public void destroy() {
    }
}

